#!/bin/csh -f
#@$-C SRAC95
#
##################################################################
#                                 
#  <<  run SRAC95 on VPP-500/42 >> 
#                                   
#  Consultant : keisuke OKUMURA, Tel 029-282-5321
#               E-mail okumura@mike.tokai.jaeri.go.jp   
#                                
##################################################################
# sample problem for BWR unit cell by Collision Probability Method
##################################################################
#    
# Fortran logical unit usage (allocate if you need)
#
#       The meaning of each file depends on sub-programs used in SRAC.
#       [ ]:important files for users. 
# 
#   1   binary (ANISN,TWOTRAN,CIATION)
#   2   binary (ANISN,CITATION), scratch
#   3   binary (SRAC,ANISN,TWOTRAN,CITATION), scratch
#   4   binary (PIJ,ANISN,TWOTRAN), scratch
# [ 5]  text:80 standard input
# [ 6]  text:137 standard output, monitoring message
#   8   binary (ANISN,TWOTRAN), angular flux in TWOTRAN
#   9   binary (TWOTRAN,CITATION)
#               flux map in CITATION, angular flux in TWOTRAN
#  10   binary (ANISN,TWOTRAN,CITATION), scratch
#  11   binary (TWOTRAN,CITATION), Sn constants in TWOTRAN
#  12   binary (TWOTRAN), restart file for TWOTRAN
#  13   binary (TWOTRAN,CITATION), restart file for TWOTRAN & CITATION
#  14   binary (TWOTRAN,CITATION), scratch
#  15   binary (CITATION), scratch (fast I/O device may be effective)
#  16   binary (CITATION), scratch
#  17   binary (CITATION), fixed source in CITATION
#  18   binary (CITATION), scratch
#  19   binary (CITATION), scratch 
#  20   binary (CITATION), scratch
#  21   binary (PIJ), scratch
#  22   binary (PIJ,CITATION), scratch
#  26   binary (CITATION), scratch
#  28   binary (CITATION), scratch
#  31   text:80 (SRAC-CVMACT,CITATION), macro-XS interface for CITATION
#  32   binary (PIJ,ANISN,TWOTRAN,TUD,CITATION)
#               fixed source for TWOTRAN, power density map in CITATION 
#  33   binary (PIJ,TWOTRAN,TUD), total flux in TWOTRAN & TUD
#  49   device internally used to access PDS file
# [50]  text:80 burnup chain library (SRAC-BURNUP) 
#  52   binary (SRAC-BURNUP), scratch
#  81   binary (PIJ), scratch
#  82   binary (PIJ), scratch
#  83   binary (PIJ), scratch
#  84   binary (PIJ), scratch
#  85   binary data table (PIJ), always required in PIJ
# [89]  plot data by piflib (SRAC-PEACO,PIJ)
#  91   text:80 (CITATION), scratch
#  92   binary (CITATION), scratch
#  93   text:80 (SRAC-BURNUP), scratch
#  95   text:80 (SRAC-DTLIST), scratch
#  96   binary (SRAC-PEACO), scratch
#  97   binary (SRAC-BURNUP), scratch
# [98]  text:137 (SRAC-BURNUP) summary of burnup results
# [99]  text:137 calculated results
#
#============= Set by user ===================================
#
#  LMN    : load module name
#           =SRACvp.50m  (for vpps : main/1.2M words, incore-PDS/7M words)
#           =SRACvp.100m (for vppm : main/7.0M words, incore-PDS/10M words)
#           =SRACvp.200m (for vppl : main/7.0M words, incore-PDS/30M words)
#           =SRACsc.100m (for vppm : scalor version)
#           For burnup calculationis, SRACvp.100m/200m should be used
#  BRN    : burnup chain library data
#           =ucm66fp  : U-Np-Pu-Am-Cm & 65+1 FP & B-10 (standard model)
#           =thcm66fp : Th-Pa-U-Np-Pu-Cm & 65+1 FP & B-10 (Th model)
#           =ucm34fp  : U-Np-Pu-Am-Cm & 30+4 FP & B-10 (simple FP model)
#  ODR    : directory name in which output data will be stored 
#  CASE   : case name which is refered as names of output files and PDS
#     
# 
   set LMN  = SRACvp.50m
   set BRN  = ucm66fp
   set ODR  = $HOME/outp
   set CASE = BWRTest85
#
   set WKU  = /wka1/`logname`
#
#=============  mkdir for PDS  ================================
#
#  PDS_DIR : directory name of PDS files
#  PDS file names must be identical with those in input data  
#
   set PDS_DIR = $WKU/$CASE
   mkdir $PDS_DIR
   mkdir $PDS_DIR/UFAST
   mkdir $PDS_DIR/UTHERMAL
   mkdir $PDS_DIR/UMCROSS
   mkdir $PDS_DIR/MACROWRK
   mkdir $PDS_DIR/MACRO
   mkdir $PDS_DIR/FLUX
   mkdir $PDS_DIR/MICREF
#  
#=============  Change if you like ============================
#
   set SRAC_DIR = /dg02/ufs02/j9347/SRAC98/SRAC
   set LM       = $SRAC_DIR/bin/$LMN
   set DATE     = `date +%b%d.%H.%M.%S`
#
#  TMPDIR : scratch file area, if not defined /var/tmp(SSU) will be used.
#  setenv  TMPDIR  $WKV
#
   setenv  fu50  $SRAC_DIR/lib/burnlibT/$BRN
   setenv  fu85  $SRAC_DIR/lib/kintab.dat
   setenv  fu89  $ODR/$CASE.SFT89.$DATE
   setenv  fu98  $ODR/$CASE.SFT98.$DATE
   setenv  fu99  $ODR/$CASE.SFT99.$DATE
   set OUTLST =  $ODR/$CASE.SFT06.$DATE
#
#=============  Exec SRAC code with the following input data =============
#
cat - << END_DATA | timex -H $LM >& $OUTLST
BWR1
BWR Cell Burnup Calculation by Pij with NR Approximation 
1 1 1 1 0   1 4 0 1 1   0 0 0 0 2   0 1 0 0 1 / SRAC CONTROL
1.00000E-15  / GEOMETRICAL BUCKLING
/dg02/ufs02/j9347/SRAC98/SRACLIB-JDL32/pds/pfast  Old  File
/dg02/ufs02/j9347/SRAC98/SRACLIB-JDL32/pds/pthml  O    F
/dg02/ufs02/j9347/SRAC98/SRACLIB-JDL32/pds/pmcrs  O    F
$PDS_DIR/UFAST     Scatch  Core
$PDS_DIR/UTHERMAL  S       C
$PDS_DIR/UMCROSS   S       C
$PDS_DIR/MACROWRK  S       C
$PDS_DIR/MACRO     S       C
$PDS_DIR/FLUX      S       C
$PDS_DIR/MICREF    S       C
& Caution : Directory for PDS will not be made or deleted in program.
&           If you set Scratch, members will be deleted.
61 46  1 1 /  107 group => 2 group
61(1)      /
46(1)      /
61         /
46         /

4 7 7 3 1  1 7 0 0 0  5 0 6 23 0  0 45 0   / Pij Control 
0 100 50 5 5 5 -1  0.0001  0.00001  0.001  1.0 10. 0.5  
1 1 1  2  3 3 3 / R-T
1 1 1           / X-R
1 2 3           / M-R
0.0 0.3054 0.4319 0.529  0.615  0.67375 0.7325 0.85 / RX
3 / NMAT
MOX1X01X  0  8  900.0   1.058  0.0  / MOX Pellet
XU050009  2  0  4.40524E-5      /1
XU080009  2  0  2.17045E-2      /2
XPU90009  2  0  6.73856E-4      /3
XPU00009  2  0  3.18053E-4      /4
XPU10009  2  0  1.30771E-4      /5
XPU20009  2  0  7.76602E-5      /6
XAM10009  2  0  5.99868E-6      /7
XO060009  0  0  4.59098E-2      /8
ZR21X02X  0  1  600.0   0.172  0.0  / 2 : Cladding
XZRN0008  0  0  4.32418E-02
H2O1X03X  0  2  600.0   0.0    0.0  / 3 : Moderator(42%Void)
XH01H008  0  0  2.96967E-02
XO060008  0  0  1.48483E-02
& Burnup Input
11 1 1 0 0  0 0 0 0 0  10(0)   / IBC
11(1.800E-04)                  / POWER LEVEL  MW/CM
1.0000E+2 1.000E+3 2.5000E+3 5.000E+3 7.5000E+3 
1.0000E+4 1.500E+4 2.0000E+4 2.500E+4 3.0000E+4 
4.0000E+4 / EXPOSURE (MWD/TON)


END_DATA
#
#=============  Remove PDS files if you don't keep them ==========
#
   alias rm rm
   rm -r $PDS_DIR
#
#  rm -r $PDS_DIR/UFAST
#  rm -r $PDS_DIR/UTHERMAL
#  rm -r $PDS_DIR/UMCROSS
#  rm -r $PDS_DIR/MACROWRK
#  rm -r $PDS_DIR/MACRO
#  rm -r $PDS_DIR/FLUX
#  rm -r $PDS_DIR/MICREF
